/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class HardwareConfigurationChange
implements HMCCommands {
    private static final String CPU_TYPE = HMCCommandUtils.CPU_TYPE;
    private static final String LED_TYPE = HMCCommandUtils.LED_TYPE;
    private static final String MEMORY_TYPE = HMCCommandUtils.MEMORY_TYPE;
    private static final String SLOT_TYPE = HMCCommandUtils.SLOT_TYPE;
    private static final String ADD_OPERATION = "a";
    private static final String MOVE_OPERATION = "m";
    private static final String REMOVE_OPERATION = "r";
    private static final String SET_LED_OPERATION = "s";
    private HSCCECClient hcc = null;
    private HSCLPARClient hlc = null;
    private HSCLPARClient target = null;
    private String drawerId;
    private String ledType;
    private String managedSystem;
    private String operation;
    private String physLoc;
    private String resourceType;
    private String sourcePartitionName;
    private String targetPartitionName;
    private int quantity;
    private int timeout = 5;
    private long index;
    private short detailLevel = 0;
    private short setting = (short)-1;
    private short slotId;
    private String realUser = System.getProperty("HMCRealUser.name");
    private boolean drawerSlotFlag = false;

    private int validateMinCapacityLimits(HSCLPARClient hSCLPARClient) throws HSCException {
        Hashtable hashtable = null;
        Vector vector = null;
        short s = 0;
        short s2 = 0;
        Short s3 = null;
        Short s4 = null;
        int n = 0;
        int n2 = 0;
        Integer n3 = null;
        Integer n4 = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            hashtable = hSCLPARClient.getMemoryData();
            n4 = (Integer)hashtable.get("minMems");
            n3 = (Integer)hashtable.get("allocMems");
            n = n4;
            n2 = n3;
            if (n2 - this.quantity < n) {
                return n2 - n;
            }
        } else if (this.resourceType.equals(CPU_TYPE)) {
            hashtable = hSCLPARClient.getProcessorData();
            s4 = (Short)hashtable.get("minCpus");
            s3 = (Short)hashtable.get("allocCpus");
            s = s4;
            s2 = s3;
            if (s2 - this.quantity < s) {
                return s2 - s;
            }
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            vector = hSCLPARClient.getIOSlotData();
        }
        return -1;
    }

    private int validateMaxCapacityLimits(HSCLPARClient hSCLPARClient) throws HSCException {
        Hashtable hashtable = null;
        Vector vector = null;
        boolean bl = false;
        short s = 0;
        short s2 = 0;
        Short s3 = null;
        Short s4 = null;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        Integer n3 = null;
        Integer n4 = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            hashtable = hSCLPARClient.getMemoryData();
            n4 = (Integer)hashtable.get("maxMems");
            n3 = (Integer)hashtable.get("allocMems");
            n = n4;
            n2 = n3;
            if (n2 + this.quantity > n) {
                return n - n2;
            }
        } else if (this.resourceType.equals(CPU_TYPE)) {
            hashtable = hSCLPARClient.getProcessorData();
            s4 = (Short)hashtable.get("maxCpus");
            s3 = (Short)hashtable.get("allocCpus");
            s = s4;
            s2 = s3;
            if (s2 + this.quantity > s) {
                return s - s2;
            }
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            vector = hSCLPARClient.getIOSlotData();
        }
        return -1;
    }

    private int validateQuantity(HSCLPARClient hSCLPARClient) throws HSCException {
        Hashtable hashtable = null;
        Vector vector = null;
        int n = 0;
        Integer n2 = null;
        short s = 0;
        Short s2 = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            hashtable = hSCLPARClient.getMemoryData();
            n2 = (Integer)hashtable.get("freeMems");
            n = n2;
            if (n < this.quantity) {
                return n;
            }
        } else if (this.resourceType.equals(CPU_TYPE)) {
            hashtable = hSCLPARClient.getProcessorData();
            s2 = (Short)hashtable.get("freeCpus");
            s = s2;
            if (s < this.quantity) {
                return s;
            }
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            vector = hSCLPARClient.getIOSlotData();
        }
        return -1;
    }

    private void doAddOperation() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        int n = 0;
        String string3 = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            n = this.validateQuantity(this.hlc);
            if (n != -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string = "The quantity to be added exceeds the available resources. There are " + objectArray[0] + " resources currently available. Please " + " retry command.";
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES", string, objectArray);
                throw new HSCException(string2);
            }
            n = this.validateMaxCapacityLimits(this.hlc);
            if (n != -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string = "The quantity to be added exceeds the available resources. There are " + (String)objectArray[0] + " resources currently available. Please " + " retry command.";
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES", string, objectArray);
                throw new HSCException(string2);
            }
            this.hlc.addMem(this.quantity, this.timeout, this.detailLevel);
            string3 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_MEM_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2157, string3, null, this.realUser);
        } else if (this.resourceType.equals(CPU_TYPE)) {
            n = this.validateQuantity(this.hlc);
            if (n != -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES", null, objectArray);
                throw new HSCException(string2);
            }
            n = this.validateMaxCapacityLimits(this.hlc);
            if (n != -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "DLPAR_ABOVE_FREE_RESOURCES", null, objectArray);
                throw new HSCException(string2);
            }
            this.hlc.addCpu(this.quantity, this.timeout, this.detailLevel);
            string3 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_CPU_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2154, string3, null, this.realUser);
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            Hashtable hashtable = null;
            Hashtable<String, Object[]> hashtable2 = null;
            Short s = null;
            String string4 = null;
            String string5 = null;
            String[] stringArray = new String[1];
            Short[] shortArray = new Short[1];
            Short[] shortArray2 = new Short[1];
            String[] stringArray2 = new String[1];
            Vector vector = null;
            boolean bl = false;
            HSCCECClient hSCCECClient = (HSCCECClient)this.hlc.getParentObject();
            vector = hSCCECClient.getFreeIOSlotData();
            for (int i = 0; i < vector.size(); ++i) {
                hashtable = (Hashtable)vector.get(i);
                if (this.drawerSlotFlag) {
                    string4 = (String)hashtable.get("IODrawerDeviceID");
                    s = (Short)hashtable.get("SlotID");
                    if (s != this.slotId || !string4.equals(this.drawerId)) continue;
                    bl = true;
                    break;
                }
                string5 = (String)hashtable.get("SlotLocation");
                if (!string5.equals(this.physLoc)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_MATCHING_SLOT");
                throw new HSCException(string2);
            }
            stringArray[0] = (String)hashtable.get("IODrawerDeviceID");
            shortArray[0] = (Short)hashtable.get("SlotID");
            shortArray2[0] = (Short)hashtable.get("PCIBus");
            stringArray2[0] = (String)hashtable.get("SlotLocation");
            hashtable2 = new Hashtable<String, Object[]>();
            hashtable2.put("IODrawerDeviceID", stringArray);
            hashtable2.put("SlotID", shortArray);
            hashtable2.put("PCIBus", shortArray2);
            hashtable2.put("SlotLocation", stringArray2);
            this.hlc.addSlots(hashtable2, this.timeout, this.detailLevel);
            string3 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_SLOT_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2160, string3, null, this.realUser);
        }
    }

    private void doRemoveOperation() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        int n = 0;
        String string2 = null;
        if (this.resourceType.equals(MEMORY_TYPE)) {
            n = this.validateMinCapacityLimits(this.hlc);
            if (n != -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string = HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "2908", null, objectArray);
                throw new HSCException(string);
            }
            this.hlc.removeMem(this.quantity, this.timeout, this.detailLevel);
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_MEM_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2158, string2, null, this.realUser);
        } else if (this.resourceType.equals(CPU_TYPE)) {
            n = this.validateMinCapacityLimits(this.hlc);
            if (n != -1) {
                objectArray = new String[]{new Integer(n).toString()};
                string = HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "2903", null, objectArray);
                throw new HSCException(string);
            }
            this.hlc.removeCpu(this.quantity, this.timeout, this.detailLevel);
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_CPU_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2155, string2, null, this.realUser);
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            this.validateMinCapacityLimits(this.hlc);
            Hashtable hashtable = null;
            Short s = null;
            String string3 = null;
            String string4 = null;
            Vector vector = null;
            boolean bl = false;
            Hashtable<String, Object[]> hashtable2 = null;
            String[] stringArray = new String[1];
            Short[] shortArray = new Short[1];
            Short[] shortArray2 = new Short[1];
            String[] stringArray2 = new String[1];
            vector = this.hlc.getChangableIOSlotData();
            for (int i = 0; i < vector.size(); ++i) {
                hashtable = (Hashtable)vector.get(i);
                if (this.drawerSlotFlag) {
                    string3 = (String)hashtable.get("IODrawerDeviceID");
                    s = (Short)hashtable.get("SlotID");
                    if (s != this.slotId || !string3.equals(this.drawerId)) continue;
                    bl = true;
                    break;
                }
                string4 = (String)hashtable.get("SlotLocation");
                if (!string4.equals(this.physLoc)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_MATCHING_SLOT1");
                throw new HSCException(string);
            }
            stringArray[0] = (String)hashtable.get("IODrawerDeviceID");
            shortArray[0] = (Short)hashtable.get("SlotID");
            shortArray2[0] = (Short)hashtable.get("PCIBus");
            stringArray2[0] = (String)hashtable.get("SlotLocation");
            hashtable2 = new Hashtable<String, Object[]>();
            hashtable2.put("IODrawerDeviceID", stringArray);
            hashtable2.put("SlotID", shortArray);
            hashtable2.put("PCIBus", shortArray2);
            hashtable2.put("SlotLocation", stringArray2);
            this.hlc.removeSlots(hashtable2, this.timeout, this.detailLevel);
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_SLOT_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2161, string2, null, this.realUser);
        }
    }

    private void doMoveOperation() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        int n = 0;
        String string2 = null;
        n = this.validateMinCapacityLimits(this.hlc);
        if (n != -1) {
            objectArray = new String[]{new Integer(n).toString()};
            string = this.resourceType.equals(MEMORY_TYPE) ? HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "2908", null, objectArray) : HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "2903", null, objectArray);
            throw new HSCException(string);
        }
        n = this.validateMaxCapacityLimits(this.target);
        if (n != -1) {
            objectArray = new String[]{new Integer(n).toString()};
            string = this.resourceType.equals(MEMORY_TYPE) ? HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "2907", null, objectArray) : HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "2904", null, objectArray);
            throw new HSCException(string);
        }
        if (this.resourceType.equals(MEMORY_TYPE)) {
            this.hlc.moveMem(this.quantity, this.targetPartitionName, false, this.timeout, this.detailLevel);
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_MEM_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2159, string2, null, this.realUser);
        } else if (this.resourceType.equals(CPU_TYPE)) {
            this.hlc.moveCpu(this.quantity, this.targetPartitionName, false, this.timeout, this.detailLevel);
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_CPU_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2156, string2, null, this.realUser);
        } else if (this.resourceType.equals(SLOT_TYPE)) {
            Hashtable hashtable = null;
            Short s = null;
            String string3 = null;
            String string4 = null;
            Vector vector = null;
            boolean bl = false;
            Hashtable<String, Object[]> hashtable2 = null;
            String[] stringArray = new String[1];
            Short[] shortArray = new Short[1];
            Short[] shortArray2 = new Short[1];
            String[] stringArray2 = new String[1];
            vector = this.hlc.getChangableIOSlotData();
            for (int i = 0; i < vector.size(); ++i) {
                hashtable = (Hashtable)vector.get(i);
                if (this.drawerSlotFlag) {
                    string3 = (String)hashtable.get("IODrawerDeviceID");
                    s = (Short)hashtable.get("SlotID");
                    if (s != this.slotId || !string3.equals(this.drawerId)) continue;
                    bl = true;
                    break;
                }
                string4 = (String)hashtable.get("SlotLocation");
                if (!string4.equals(this.physLoc)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_MATCHING_SLOT1");
                throw new HSCException(string);
            }
            stringArray[0] = (String)hashtable.get("IODrawerDeviceID");
            shortArray[0] = (Short)hashtable.get("SlotID");
            shortArray2[0] = (Short)hashtable.get("PCIBus");
            stringArray2[0] = (String)hashtable.get("SlotLocation");
            hashtable2 = new Hashtable<String, Object[]>();
            hashtable2.put("IODrawerDeviceID", stringArray);
            hashtable2.put("SlotID", shortArray);
            hashtable2.put("PCIBus", shortArray2);
            hashtable2.put("SlotLocation", stringArray2);
            this.hlc.moveSlots(hashtable2, this.targetPartitionName, false, this.timeout, this.detailLevel);
            string2 = HSCResourceBundleUtil.getMessage("DLPARBundle", "INFO_SLOT_SUCCESS");
            HSCLogUtils.logSystemEvent((short)2162, string2, null, this.realUser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doSetLEDOperation() throws HSCException, RequiredParameterException {
        Object var1_1 = null;
        String string = null;
        Vector<Long> vector = new Vector<Long>();
        Vector<Short> vector2 = new Vector<Short>();
        vector.add(new Long(this.index));
        vector2.add(new Short(this.setting));
        if (this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION)) {
            if (this.hcc.isSystemAttentionSupported()) {
                this.hcc.setSystemAttentionState(vector, vector2);
                return;
            }
            string = HSCResourceBundleUtil.getMessage("CECBundle", "LED_SYSTEM_ATTENTION_NOT_SUPPORTED");
            throw new HSCException(string);
        }
        if (this.hcc.isIdentifySupported()) {
            this.hcc.setIdentifyState(vector, vector2);
            return;
        }
        string = HSCResourceBundleUtil.getMessage("CECBundle", "LED_IDENTIFY_NOT_SUPPORTED");
        throw new HSCException(string);
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCLPARClient hSCLPARClient = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        if (this.operation.equals(ADD_OPERATION) || this.operation.equals(REMOVE_OPERATION) || this.operation.equals(MOVE_OPERATION)) {
            this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.sourcePartitionName, false);
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
            if (this.hlc != null && !this.hlc.dlparEnabled(this.resourceType)) {
                string = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_DLPAR_NOT_ENABLED");
                throw new HSCException(string);
            }
            if (this.hlc != null && this.hlc.affinityPartition()) {
                if (this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(MEMORY_TYPE)) {
                    string = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_DLPAR_NOT_ENABLED");
                    throw new HSCException(string);
                }
            } else if (this.hlc != null && this.hlc.smpPartition()) {
                string = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_DLPAR_NOT_ENABLED");
                throw new HSCException(string);
            }
            if (this.operation.equals(MOVE_OPERATION)) {
                this.target = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.targetPartitionName, false);
                if (null == this.target) {
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                    throw new HSCException(string);
                }
                if (this.target != null && !this.target.dlparEnabled(this.resourceType)) {
                    string = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_DLPAR_NOT_ENABLED");
                    throw new HSCException(string);
                }
            }
        }
        if (this.operation.equals(SET_LED_OPERATION)) {
            this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
        }
        if (this.operation.equals(MOVE_OPERATION) && (hSCLPARClient = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.targetPartitionName, false)) != null && !hSCLPARClient.dlparEnabled(this.resourceType)) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "TARGET_PARTITION_DLPAR_NOT_ENABLED");
            throw new HSCException(string);
        }
    }

    private void checkAddRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        if (this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(CPU_TYPE)) {
            if (this.managedSystem == null || this.operation == null || this.resourceType == null || this.sourcePartitionName == null || this.detailLevel == -1 || this.quantity == 0) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + "," + HMCCommandUtils.RESOURCE_TYPE_PARAM + "," + HMCCommandUtils.QUANTITY_PARAM + "," + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + "," + HMCCommandUtils.TIMEOUT_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DETAIL_LEVEL_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(SLOT_TYPE) && (this.managedSystem == null || this.operation == null || this.resourceType == null || this.sourcePartitionName == null || this.detailLevel == -1 || (this.slotId == 0 || this.drawerId == null) && this.physLoc == null)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + "," + HMCCommandUtils.RESOURCE_TYPE_PARAM + "," + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + "," + HMCCommandUtils.TIMEOUT_PARAM + "," + HMCCommandUtils.DETAIL_LEVEL_PARAM + ", and either " + "(" + HMCCommandUtils.SLOT_ID_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DRAWER_ID_PARAM + ") " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", objectArray) + " " + HMCCommandUtils.PHYSICAL_LOCATION_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    private void checkRemoveRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        if (this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(CPU_TYPE)) {
            if (this.managedSystem == null || this.operation == null || this.resourceType == null || this.sourcePartitionName == null || this.detailLevel == -1 || this.quantity == 0) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.QUANTITY_PARAM + "," + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ", " + HMCCommandUtils.TIMEOUT_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DETAIL_LEVEL_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(SLOT_TYPE) && (this.managedSystem == null || this.operation == null || this.resourceType == null || this.sourcePartitionName == null || this.detailLevel == -1 || (this.slotId == 0 || this.drawerId == null) && this.physLoc == null)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + "," + HMCCommandUtils.RESOURCE_TYPE_PARAM + "," + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + "," + HMCCommandUtils.TIMEOUT_PARAM + "," + HMCCommandUtils.DETAIL_LEVEL_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND_EITHER", "and either", null) + " (" + HMCCommandUtils.SLOT_ID_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DRAWER_ID_PARAM + ") " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.PHYSICAL_LOCATION_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    private void checkMoveRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        Object[] objectArray = null;
        if (this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(CPU_TYPE)) {
            if (this.managedSystem == null || this.operation == null || this.resourceType == null || this.sourcePartitionName == null || this.detailLevel == -1 || this.quantity == 0) {
                objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + "," + HMCCommandUtils.RESOURCE_TYPE_PARAM + "," + HMCCommandUtils.QUANTITY_PARAM + "," + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + "," + HMCCommandUtils.TIMEOUT_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DETAIL_LEVEL_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
                throw new RequiredParameterException(string);
            }
        } else if (this.resourceType.equals(SLOT_TYPE) && (this.managedSystem == null || this.operation == null || this.resourceType == null || this.sourcePartitionName == null || this.detailLevel == -1 || (this.slotId == 0 || this.drawerId == null) && this.physLoc == null)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.OPERATION_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ", " + HMCCommandUtils.TIMEOUT_PARAM + ", " + HMCCommandUtils.DETAIL_LEVEL_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND_EITHER", "and either", null) + "(" + HMCCommandUtils.SLOT_ID_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DRAWER_ID_PARAM + ") " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.PHYSICAL_LOCATION_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    private void checkSetLEDRequiredParameters() throws RequiredParameterException {
        Object var1_1 = null;
        String string = null;
        Object[] objectArray = null;
        if (this.setting != HMCCommandUtils.LED_SETTING_VALUE_OFF && this.setting != HMCCommandUtils.LED_SETTING_VALUE_ON || this.ledType == null || !this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION) && !this.ledType.equals(HMCCommandUtils.LED_TYPE_VALUE_IDENTIFY)) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + "," + HMCCommandUtils.RESOURCE_TYPE_PARAM + "," + HMCCommandUtils.LED_INDEX_PARAM + "," + HMCCommandUtils.LED_SETTING_PARAM + "," + HMCCommandUtils.LED_TYPE_PARAM + ","};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.resourceType || null == this.operation || null == this.managedSystem) {
            objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command are " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + ", and " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.operation.equals(MOVE_OPERATION)) {
            this.checkMoveRequiredParameters();
        } else if (this.operation.equals(ADD_OPERATION)) {
            this.checkAddRequiredParameters();
        } else if (this.operation.equals(REMOVE_OPERATION)) {
            this.checkRemoveRequiredParameters();
        } else if (this.operation.equals(SET_LED_OPERATION)) {
            this.checkSetLEDRequiredParameters();
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.initializeClients();
        if (this.operation.equals(ADD_OPERATION)) {
            this.doAddOperation();
        } else if (this.operation.equals(REMOVE_OPERATION)) {
            this.doRemoveOperation();
        } else if (this.operation.equals(MOVE_OPERATION)) {
            this.doMoveOperation();
        } else if (this.operation.equals(SET_LED_OPERATION)) {
            this.doSetLEDOperation();
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = null;
        String string8 = (String)hashMap.get(HMCCommandUtils.DETAIL_LEVEL_PARAM);
        if (string8 != null && string8.length() != 0) {
            this.detailLevel = Short.parseShort(string8);
        }
        if ((string6 = (String)hashMap.get(HMCCommandUtils.SLOT_ID_PARAM)) != null && string6.length() != 0) {
            this.slotId = Short.parseShort(string6);
        }
        if ((string5 = (String)hashMap.get(HMCCommandUtils.LED_INDEX_PARAM)) != null && string5.length() != 0) {
            this.index = Long.parseLong(string5);
        }
        if ((string4 = (String)hashMap.get(HMCCommandUtils.QUANTITY_PARAM)) != null && string4.length() != 0) {
            this.quantity = Integer.parseInt(string4);
        }
        if ((string3 = (String)hashMap.get(HMCCommandUtils.LED_SETTING_PARAM)) != null) {
            if (string3.equals(HMCCommandUtils.LED_SETTING_ON)) {
                this.setting = HMCCommandUtils.LED_SETTING_VALUE_ON;
            } else if (string3.equals(HMCCommandUtils.LED_SETTING_OFF)) {
                this.setting = HMCCommandUtils.LED_SETTING_VALUE_OFF;
            } else {
                string7 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
                throw new RequiredParameterException(string7);
            }
        }
        if ((string2 = (String)hashMap.get(HMCCommandUtils.TIMEOUT_PARAM)) != null) {
            this.timeout = Integer.parseInt(string2);
        }
        if ((string = (String)hashMap.get(HMCCommandUtils.LED_TYPE_PARAM)) != null) {
            if (string.equals(HMCCommandUtils.LED_TYPE_SYSTEM_ATTENTION)) {
                this.ledType = HMCCommandUtils.LED_TYPE_VALUE_SYSTEM_ATTENTION;
            } else if (string.equals(HMCCommandUtils.LED_TYPE_IDENTIFY)) {
                this.ledType = HMCCommandUtils.LED_TYPE_VALUE_IDENTIFY;
            } else {
                string7 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
                throw new RequiredParameterException(string7);
            }
        }
        this.operation = (String)hashMap.get(HMCCommandUtils.OPERATION_PARAM);
        if (!(this.operation == null || this.operation.equals(ADD_OPERATION) || this.operation.equals(REMOVE_OPERATION) || this.operation.equals(MOVE_OPERATION) || this.operation.equals(SET_LED_OPERATION))) {
            string7 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
            throw new RequiredParameterException(string7);
        }
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        if (!(this.resourceType == null || this.resourceType.equals(CPU_TYPE) || this.resourceType.equals(LED_TYPE) || this.resourceType.equals(MEMORY_TYPE) || this.resourceType.equals(SLOT_TYPE))) {
            string7 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
            throw new RequiredParameterException(string7);
        }
        this.drawerId = (String)hashMap.get(HMCCommandUtils.DRAWER_ID_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.physLoc = (String)hashMap.get(HMCCommandUtils.PHYSICAL_LOCATION_PARAM);
        this.sourcePartitionName = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        this.targetPartitionName = (String)hashMap.get(HMCCommandUtils.TARGET_PARTITION_NAME_PARAM);
        if (this.managedSystem == null || this.operation == null || this.resourceType == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.MANAGED_SYSTEM_PARAM + "," + HMCCommandUtils.OPERATION_PARAM + ", and " + HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string7 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string7);
        }
        if (this.drawerId != null && this.slotId != 0) {
            this.drawerSlotFlag = true;
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HARDWARE_CONFIGURATION_CHANGE_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        HardwareConfigurationChange hardwareConfigurationChange = new HardwareConfigurationChange();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                hardwareConfigurationChange.printHelp();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                arrayList.add(string2);
                if (!string2.equals(HMCCommandUtils.HELP_PARAM)) continue;
                hardwareConfigurationChange.printHelp();
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                hardwareConfigurationChange.mapParameters(hashMap);
                hardwareConfigurationChange.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

